﻿<%@ WebService Language="C#" CodeBehind="P8xxxBinIn.asmx.cs" Class="WebSensorWebServiceExamples.P8xxxBinIn" %>

//
// Read SOAP message example for devices P8552, P8652, P8653
//
// Requirements: P8552, P8652, P8653 device with firmware version 4-5-8-2 or higher
//               IIS 7 server
//
//  Purpose of this example is demonstration of communication with P8552, P8652, P8653 devices.
//  It is not intended to be used in production environment without further changes.
//

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Serialization;

namespace WebSensorWebServiceExamples
{
  /// <summary>
  /// Example of collecting SOAP messages from P8xxx Web Sensor with binary inputs.
  /// Edit constant FILENAME to requested ouptut file location.
  /// </summary>
  [SoapDocumentService(RoutingStyle = SoapServiceRoutingStyle.RequestElement)]
  [WebService(Namespace = "http://cometsystem.cz/schemas/soapP8xxxBinIn.xsd")]
  public class P8xxxBinIn : System.Web.Services.WebService
  {
    public const string FILENAME = @"d:\P8xxxBinIn.txt";

    [WebMethod]
    public void InsertP8xxxBinInSample([XmlElement("name")]string DeviceName,
                                       [XmlElement("sn")]int SerialNumber,
                                       [XmlElement("tmr")]int SendingInterval,
                                       [XmlElement("kind")]int DeviceCode,
                                       [XmlElement("c")]List<AnalogChannel> AnalogChannels,
                                       [XmlElement("b")]List<BinaryChannel> BinaryChannels)
    {
      StringBuilder sb = new StringBuilder();
      sb.AppendLine(String.Format("Device name: {0}", DeviceName));
      sb.AppendLine(String.Format("Serial number: {0}", SerialNumber));
      sb.AppendLine(String.Format("Device code: {0}", DeviceCode));
      sb.AppendLine(String.Format("Sending interval: {0}", SendingInterval));

      sb.AppendLine();
      sb.AppendLine("Analog channels:");
      foreach (var analogChannel in AnalogChannels)
      {
        if (analogChannel.Enabled)
        {
          string unit;
          switch (analogChannel.Unit.ToLower())
          {
            case "c":
              unit = "°C";
              break;
            case "f":
              unit = "°F";
              break;
            case "rh":
              unit = "%";
              break;
            default:
              unit = "n/a";
              break;
          }
          string alarm;
          switch (analogChannel.Alarm.ToLower())
          {
            case "lo":
              alarm = "Low alarm active";
              break;
            case "hi":
              alarm = "High alarm active";
              break;
            default:
              alarm = "No alarm active";
              break;
          }
          string format = String.Concat("#{0} {1} = {2} {3}; {4} (low alarm limit: {5}; high alarm limit: {6})");
          sb.AppendLine(String.Format(format,
            analogChannel.ChannelNumber,
            analogChannel.Name,
            analogChannel.Value,
            unit,
            alarm,
            analogChannel.LoAlarmLimit,
            analogChannel.HiAlarmLimit));
        }
      }

      sb.AppendLine();
      sb.AppendLine("Binary channels:");
      foreach (var binaryChannel in BinaryChannels)
      {
        if (binaryChannel.Enabled)
        {
          string value = "ERROR";
          if (binaryChannel.Value == "1")
            value = binaryChannel.Binary1Description;
          else if (binaryChannel.Value == "0")
            value = binaryChannel.Binary0Descritpion;
          string alarm = binaryChannel.Alarm.ToLower() == "ac" ? "Alarm active" : "Alarm inactive";
          sb.AppendLine(String.Format("#{0} {1} = {2}; {3}",
            binaryChannel.ChannelNumber,
            binaryChannel.Name,
            value,
            alarm));
        }
      }

      if (File.Exists(FILENAME))
        File.Delete(FILENAME);
      File.WriteAllText(FILENAME, sb.ToString());
    }
  }

  public class AnalogChannel
  {
    [XmlAttribute("i")]
    public int ChannelNumber { get; set; }
    [XmlElement("e")]
    public bool Enabled { get; set; }
    [XmlElement("n")]
    public string Name { get; set; }
    [XmlElement("u")]
    public string Unit { get; set; }
    [XmlElement("p")]
    public int DecimalPlaces { get; set; }
    [XmlElement("v")]
    public double Value { get; set; }
    [XmlElement("a")]
    public string Alarm { get; set; }
    [XmlElement("h")]
    public double HiAlarmLimit { get; set; }
    [XmlElement("l")]
    public double LoAlarmLimit { get; set; }
  }
  public class BinaryChannel
  {
    [XmlAttribute("i")]
    public int ChannelNumber { get; set; }
    [XmlElement("e")]
    public bool Enabled { get; set; }
    [XmlElement("n")]
    public string Name { get; set; }
    [XmlElement("b0")]
    public string Binary0Descritpion { get; set; }
    [XmlElement("b1")]
    public string Binary1Description { get; set; }
    [XmlElement("v")]
    public string Value { get; set; }
    [XmlElement("a")]
    public string Alarm { get; set; }
  }
}
