﻿<%@ WebService Language="C#" CodeBehind="P8xxxTRh.asmx.cs" Class="WebSensorWebServiceExamples.P8xxxTRh" %>

//
// Read SOAP message example for devices P85xx/P86xx
//
// Requirements: P85xx/P86xx device (P8511, P8541, P8610, P8641, etc.) with firmware version 4-5-8-2 or higher
//               IIS 7 server
//
//  Purpose of this example is demonstration of communication with P85xx/P86xx device.
//  It is not intended to be used in production environment without further changes.
//

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Serialization;

namespace WebSensorWebServiceExamples
{
  /// <summary>
  /// Example of collecting SOAP messages from P8xxx Web Sensor for T+Rh probes
  /// Edit constant FILENAME to requested ouptut file location.
  /// </summary>
  [SoapDocumentService(RoutingStyle = SoapServiceRoutingStyle.RequestElement)]
  [WebService(Namespace = "http://cometsystem.cz/schemas/soapP8xxx.xsd")]
  public class P8xxxTRh : System.Web.Services.WebService
  {
    public const string FILENAME = @"d:\P8xxxTRh.txt";

    [WebMethod]
    public void InsertP8xxxSample([XmlElement("name")]string DeviceName,
                                  [XmlElement("sn")]int SerialNumber,
                                  [XmlElement("tmr")]int SendingInterval,
                                  [XmlElement("kind")]int DeviceCode,
                                  [XmlElement("c1")]Channel Channel1,
                                  [XmlElement("c2")]Channel Channel2,
                                  [XmlElement("c3")]Channel Channel3,
                                  [XmlElement("c4")]Channel Channel4,
                                  [XmlElement("c5")]Channel Channel5)
    {
      StringBuilder sb = new StringBuilder();
      sb.AppendLine(String.Format("Device name: {0}", DeviceName));
      sb.AppendLine(String.Format("Serial number: {0}", SerialNumber));
      sb.AppendLine(String.Format("Device code: {0}", DeviceCode));
      sb.AppendLine(String.Format("Sending interval: {0}", SendingInterval));

      sb.AppendLine();
      sb.AppendLine("Channels:");
      for (int i = 1; i <= 5; i++)
      {
        sb.AppendLine();
        sb.AppendLine(string.Format("Number: {0}", i));
        Channel ch = null;
        switch (i)
        {
          case 1: ch = Channel1; break;
          case 2: ch = Channel2; break;
          case 3: ch = Channel3; break;
          case 4: ch = Channel4; break;
          case 5: ch = Channel5; break;
        }
        sb.AppendLine(string.Format("Value: {0}", ch.Value));
        sb.AppendLine(string.Format("Unit: {0}", ch.Unit));
        sb.AppendLine(string.Format("Alarm: {0}", ch.Alarm));
        sb.AppendLine(string.Format("Enabled: {0}", ch.Enabled));
      }

      if (File.Exists(FILENAME))
        File.Delete(FILENAME);
      File.WriteAllText(FILENAME, sb.ToString());
    }
  }

  public class Channel
  {
    [XmlElement("v")]
    public double Value { get; set; }

    [XmlElement("u")]
    public string Unit { get; set; }

    [XmlElement("a")]
    public string Alarm { get; set; }

    [XmlElement("e")]
    public bool Enabled { get; set; }
  }

}
