<?php
#
# Read SOAP message example for devices P8552, P8652, P8653
#
# Requirements: P8552, P8652, P8653 device with firmware version 4-5-8-2 or higher
#               Apache server (tested with version 2.4.23)
#               PHP (tested with version 5.6.25)
#               Enabled SOAP extension for PHP (uncomment ";extension=php_soap.dll" in your php.ini)
#               P8xxxBinIn.wsdl must be in the same folder as this file
#               Uncommented line always_populate_raw_post_data = -1 in php.ini file
#               Edit $filename property to requested ouptut file location
#
#  Purpose of this example is demonstration of communication with P8552, P8652, P8653 devices.
#  It is not intended to be used in production environment without further changes.
#

function InsertP8xxxBinInSample($data)
{
  $filename = "D:\\output.txt";

  $msg = "Device name = " . $data->name . "\r\n";//DeviceName
  $msg .= "Serial number = " . $data->sn . "\r\n";//SerialNumber
  $msg .= "Device code = " . $data->kind . "\r\n";//DeviceCode
  $msg .= "Sending interval = " . $data->tmr . "\r\n";//SendingInterval

  $msg .= "\r\n";
  $msg .= "Analog channels:". "\r\n";
  foreach($data->c as $c)
  {
    if ($c->e == "1")//$c->e ..Enabled
    {
      $msg .= "ChannelNumber = " . $c->i . "\r\n";
      $msg .= "  Name = " . $c->n . "\r\n";
      $msg .= "  Unit = " . $c->u . "\r\n";
      $msg .= "  DecimalPlaces = " . $c->p . "\r\n";
      $msg .= "  Value = " . $c->v . "\r\n";
      $msg .= "  Alarm = " . $c->a . "\r\n";
      $msg .= "  HiAlarmLimit = " . $c->h . "\r\n";
      $msg .= "  LoAlarmLimit = " . $c->l . "\r\n";
    }
  }

  $msg .= "\r\n";
  $msg .= "Binary channels:". "\r\n";
  foreach($data->b as $b)
  {
    if ($b->e == "1")//$b->e ..Enabled
    {
      $msg .= "ChannelNumber = " . $b->i . "\r\n";
      $msg .= "  Name = " . $b->n . "\r\n";
      $msg .= "  Binary0Descritpion = " . $b->b0 . "\r\n";
      $msg .= "  Binary1Description = " . $b->b1 . "\r\n";
      $msg .= "  Value = " . $b->v . "\r\n";
      $msg .= "  Alarm = " . $b->a . "\r\n";
    }
  }

  $file = fopen($filename,"a");
  fwrite($file, $msg);
  fclose($file);
}

ini_set("soap.wsdl_cache_enabled", "0");
$server = new SoapServer("P8xxxBinIn.wsdl", array('uri' => "http://test-uri/"));
$server->addFunction('InsertP8xxxBinInSample');
$server->handle();

?>
